<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment\Like;

trait TraitPostCommentLikeSetters
{
    use TraitPostCommentLikeProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setLikedByUserId(string $likedByUserId)
    {
        $this -> likedByUserId = $likedByUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setLikedPostCommentId(string $likedPostCommentId)
    {
        $this -> likedPostCommentId = $likedPostCommentId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setParentPostId(string $parentPostId)
    {
        $this -> parentPostId = $parentPostId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
